/*
*******************************************************************************
*
* File:         pxbeh.h
* Description:  
* Author:       Henrik Liebau
* Created:      04 May 2000, 15:45:25
* Modified:     Wed Jun  7 18:28:07 2000 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/

#ifndef __pxbeh_H__
#define __pxbeh_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxbehdef_H__
#include <pxbehdef.h>
#endif /* defined __pxbehdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------------------*
 * bx_errtype PprBehGenerate (
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprBehGenerate (
  bx_int32 algorithm,
  bx_int32 * randomSeed,
  bxppr_vardatatype * varData,
  bxppr_behresultdatatype * behResult
  );

/*---------------------------------------------------------------------------*
 * bx_errtype PprBehReportGet ( bxppr_stringtype * reportStr,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprBehReportGet (
  bxppr_stringtype * reportStr,
  bxppr_vardatatype * varData,
  bxppr_behresultdatatype * behResult,
  bx_int32 contents,
  bx_int32 capi
  );

/*---------------------------------------------------------------------------*
 * bx_errtype PprBehProg ( bx_handletype handle,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprBehProg ( bx_handletype handle,
			bxppr_vardatatype * varData,
			bxppr_behresultdatatype * behResult,
			BEHSETFCT BehSetFct,
			GENSETFCT GenSetFct,
			MEMINITFCT MemInitFct,
			bx_int32 behGrp0 );
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprBehResultCompute ( bxppr_vardatatype * varData,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprBehResultCompute ( bxppr_vardatatype * varData,
				 bxppr_behresultdatatype * behResult,
				 bx_int32 * tuplesperm );

#ifdef __cplusplus
}
#endif

/* ----- Do not add code below this line ----- */
#endif /* defined __pxbeh_H__ */
